﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.IO;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using OpenAPI_App_Manager.UI_Components.AppDetails_Components;

using KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary;

namespace OpenAPI_App_Manager
{
    public partial class AppManager : UserControl
    {
        private Thread tAppList;
        private string errorMessage = string.Empty;

        private OpenAPIWrapper openAPIHandler;
        public OpenAPIWrapper OpenAPIHandler
        {
            get
            {
                return openAPIHandler;
            }
            set
            {
                openAPIHandler = value;
                if (openAPIHandler == null || openAPIHandler.MFP == null || openAPIHandler.MFP.Address == string.Empty || !openAPIHandler.MFP.OpenAPIEnabled)
                {
                    this.Enabled = false;
                    listViewApps.Items.Clear();
                    return;
                }
                else
                {
                    this.Enabled = true;
                    RefreshList();
                }
            }
        }

        public AppManager()
        {
            InitializeComponent();
        }

       

        private void checkBoxesViews_CheckedChanged(object sender, EventArgs e)
        {
            if (sender == checkBoxDetailView && checkBoxDetailView.Checked)
            {
                checkBoxIconView.Checked = false;
            }
            else if (sender == checkBoxDetailView && !checkBoxDetailView.Checked)
            {
                checkBoxIconView.Checked = true;
            }
            else if (sender == checkBoxIconView && checkBoxIconView.Checked)
            {
                checkBoxDetailView.Checked = false;
            }
            else if (sender == checkBoxIconView && !checkBoxIconView.Checked)
            {
                checkBoxDetailView.Checked = true;
            }

            if (checkBoxDetailView.Checked)
                listViewApps.View = View.Details;
            else
                listViewApps.View = View.LargeIcon;
        }

        private void buttonRefresh_Click(object sender, EventArgs e)
        {
            RefreshList();
        }

        private void RefreshList()
        {
            labelProgress.Text = "Reading Application List";
            progressBar.Maximum = 1;
            if (tAppList != null)
            {
                while (tAppList.IsAlive)
                    Thread.Sleep(250);
            }
            tAppList = new Thread(new ThreadStart(GetAppList));
            tAppList.Start();
        }

        private void GetAppList()
        {
            BeBusy(true);          

            try
            {
                KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection resAppList = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection();
                ConnectionResult cr = openAPIHandler.GetApplicationList(out resAppList);
                if (cr == ConnectionResult.Ack)
                {
                    ClearList();
                    if (resAppList.Count == 0)
                    {
                        Progress("MFP has no applications");
                    }
                    foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfo app in resAppList)
                    {
                        string szAppType = GetAppType(app.FunctionVersion.ApplicationType);
                        string szAppVer = app.FunctionVersion.Major + "." + app.FunctionVersion.Minor;
                        if (app.FunctionVersion.Special != null && app.FunctionVersion.Special != string.Empty)
                            szAppVer += app.FunctionVersion.Special;
                        ListViewItem lvi = new ListViewItem(new string[] { app.Name, app.No.ToString(), szAppType, szAppVer });
                        lvi.Tag = app.Name;
                        lvi.ToolTipText = app.Name + Environment.NewLine + szAppType + " " + szAppVer;
                        switch (app.FunctionVersion.ApplicationType)
                        {
                            case "1": lvi.ImageIndex = 0; break;
                            case "2": lvi.ImageIndex = 12; break;
                            case "3": lvi.ImageIndex = 1; break;
                            case "4": lvi.ImageIndex = 2; break;
                            case "5": lvi.ImageIndex = 3; break;
                            case "6": lvi.ImageIndex = 7; break;
                            case "7": lvi.ImageIndex = 10; break;
                            case "8": lvi.ImageIndex = 8; break;
                            case "9": lvi.ImageIndex = 9; break;
                            case "10": lvi.ImageIndex = 5; break;
                            case "11": lvi.ImageIndex = 4; break;
                            case "12": lvi.ImageIndex = 13; break;
                            case "200": lvi.ImageIndex = 6; break;
                            default: lvi.ImageIndex = 11; break;
                        }
                        AddLVI(lvi);
                    }
                    Progress("Retrieved application list");
                }
                else
                {
                    //Error encountered getting application list
                    string szError = "Failed to get application list";
                    try
                    {
                        szError += ": " + openAPIHandler.SetupMainControlManager.LastConnectionError.ErrorInfoList.StatusErrorInfo[0].Result.ErrorInfo.Description;
                    }
                    catch { }
                    RecordError(szError);
                    Progress(szError);
                }
            }
            catch (KONICAMINOLTA.OpenAPISDK.Common.SdkException.SdkException)
            {
                //SDK exceptions are generally caught if the MFP SAYS it supports OpenAPI but really
                //doesn't (e.g. bizhub PRO 1200).  Just ignore it.
                Progress(string.Empty);
            }
            catch (Exception ex)
            {
                //Other error encountered
                string szError = "Critical error encountered, forced to stop: " + ex.Message;
                RecordError(szError);
                Progress(szError);
            }
            BeBusy(false);
        }

        private string GetAppType(string AppType)
        {
            switch (AppType)
            {
                case "1": return "Scan Type-D";
                case "2": return "Scan Type-S";
                case "3": return "PullPrint";
                case "4": return "Job Management";
                case "5": return "Authentication";
                case "6": return "Setup";
                case "7": return "Browser Authentication";
                case "8": return "Browser Scan";
                case "9": return "Browser PullPrint";
                case "10": return "Screen Saver";
                case "11": return "Browser Launcher";
                case "12": return "General Browser";
                case "200": return "OtherA";
                default: return "Unknown (" + AppType + ")";
            }
        }

        private void buttonDelete_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(new ParameterizedThreadStart(DeleteApps));
            Dictionary<int, string> dApps = new Dictionary<int, string>();
            foreach (ListViewItem lvi in listViewApps.SelectedItems)
                dApps.Add(int.Parse(lvi.SubItems[1].Text), lvi.SubItems[0].Text);
            progressBar.Maximum = dApps.Count;
            t.Start(dApps);
        }

        private void buttonGetDetails_Click(object sender, EventArgs e)
        {
            //Get Details String
            string szDetails = String.Empty;

            //ConnectionResult object
            KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult connectionResult;

            // Get the Application ID of the specific application from the user 

            // Creates the form to display to the user to get the application ID
            frmAppID winAppID = new frmAppID();
            //Display the form
            DialogResult dialogResult = winAppID.ShowDialog();
            if (dialogResult == DialogResult.Cancel)
                return;
            
            //Get the application ID from the UI
            string szAppID = winAppID.szAppID;

            try
            {
                // Initializing ServerDetails component
                ServerDetails serverdetails = new ServerDetails();

                // Initializing BrowserInfo component
                BrowserInfo browserinfo = new BrowserInfo();

                //Get the application list - this returns ConnectionResult
                //Get the Application Number from the selected application in the UI
                int iAppNo = int.Parse(listViewApps.SelectedItems[0].SubItems[1].Text); //Application Number column

                //Get the Application Type from the selected application in the UI
                string szAppType = listViewApps.SelectedItems[0].SubItems[2].Text; //Application Type column

                switch (szAppType) //Get the Type
                {
                    case "Scan Type-D":
                        #region Get STA Type D Application Details
                        //Get the application details of Scan Type D application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanTypeDApplicationSetting scanDApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanTypeDApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetScanApplication(iAppNo, szAppID, out scanDApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //STA Type D Application Details                            

                            //Get the Application Server Information                            
                            //Get Server Address                            
                            serverdetails.textBoxAddress.Text = scanDApplicationSetting.Server.Address;
                            //Get Server Port No                            
                            serverdetails.textBoxPort.Text = scanDApplicationSetting.Server.Port.ToString();
                            //Get whether SSL is ON or OFF
                            serverdetails.optionStateSSL.Checked = scanDApplicationSetting.Server.UseSSL;
                            
                            //Get Server Timeout information
                            serverdetails.textBoxTimeOut.Text = scanDApplicationSetting.Server.Timeout.ToString();
                            
                            //Get the Authentication Type
                            serverdetails.textBoxAuthenticationType.Text = scanDApplicationSetting.Function.AuthenticationType.ToString();
                            
                            //Get Application Job Notify Server Settings                            
                            //scanDApplicationSetting.Function.EnableJobNotify means Job Notification is enabled
                            serverdetails.optionStateJobNotify.Checked = scanDApplicationSetting.Function.EnableJobNotify;
                            serverdetails.labelAppNode.Visible = false;
                            serverdetails.textBoxAppNode.Visible = false;
                            serverdetails.optionStateRelayServerAuth.Visible = false;
                            serverdetails.groupBoxJobNotify.Enabled = scanDApplicationSetting.Function.EnableJobNotify;
                            if (scanDApplicationSetting.Function.EnableJobNotify)
                            {                            
                                //Get the Job Notification Address
                                serverdetails.textBoxJobNotifyAddress.Text = scanDApplicationSetting.Function.JobNotifyServer.Address;                             
                                //Get the Job Notification Port No
                                serverdetails.textBoxJobNotifyPort.Text = scanDApplicationSetting.Function.JobNotifyServer.Port.ToString();
                                //Get the Job Notification Server SSL is ON or OFF
                                serverdetails.optionStateJobNotifySSL.Checked = scanDApplicationSetting.Function.JobNotifyServer.UseSSL;                                
                            }
                            else
                            {
                                szDetails += "Job Notify -->  Disabled" + Environment.NewLine;
                            }

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically
                            getDetails.flowLayoutPanel.Controls.Add(serverdetails);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);                            
                            //Display the dialog to the user
                            getDetails.ShowDialog();

                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Scan Type-S":
                        #region Get STA Type S Application Details
                        //Get the application details of Scan Type S application
                        Scan_S scans = new Scan_S();
                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanTypeSApplicationSetting scanSApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanTypeSApplicationSetting();
                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetScanApplication(iAppNo, szAppID, out scanSApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //STA Type S Application Details                            
                            // Get Scan Setting Color Mode                            
                            scans.optionStateColorVisible.Checked = scanSApplicationSetting.ScanSetting.Color.Visible;                            
                            //Get whether Scan Setting Color Mode Edit is allowed or not.
                            scans.optionStateColorAllowEdit.Checked = scanSApplicationSetting.ScanSetting.Color.AllowEdit;                           
                            //get the list of Selectable Color Modes
                            scans.textBoxColorSelectable.Text = scanSApplicationSetting.ScanSetting.Color.SelectableItems.Count.ToString();                            

                            //ColorItem number
                            int count = 1;  
                          
                            string scancoloritem="";
                            foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanColorItem scanColorItem in scanSApplicationSetting.ScanSetting.Color.SelectableItems)
                            {
                                //Get the type of Color Item if selected
                                scancoloritem += count + ". " + scanColorItem.Type;                                
                                if (scanColorItem.Selected)
                                {
                                    scancoloritem += "(Default Color)";                                    
                                }                                
                                scancoloritem += Environment.NewLine;
                                count++;
                            }
                            scans.textBoxColorList.Text = scancoloritem;                            

                            //Get Resolution Settings                       
                            //Get whether Resolution Mode is visible or not.
                            scans.optionStateResolutionVisible.Checked = scanSApplicationSetting.ScanSetting.Resolution.Visible;                            
                            //Get Resolution Setting Edit allowed or not.
                            scans.optionStateResolutionAllowEdit.Checked = scanSApplicationSetting.ScanSetting.Resolution.AllowEdit;                            
                            //get the list of Selectable Resolution Mode
                            scans.textBoxResolutionSelectable.Text = scanSApplicationSetting.ScanSetting.Resolution.SelectableItems.Count.ToString();
                            
                            //ResolutionItem number
                            count = 1;

                            string resolutionitem = "";
                            foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanResolutionItem scanResolutionItem in scanSApplicationSetting.ScanSetting.Resolution.SelectableItems)
                            {
                                //Get the type of Resolution Item
                                resolutionitem +=  count + ". " + scanResolutionItem.Type;                            
                                if (scanResolutionItem.Selected)
                                {
                                    resolutionitem += "(Default Resolution)";                                    
                                }
                                resolutionitem += Environment.NewLine;                                
                                count++;
                            }
                            scans.textBoxResolutionList.Text = resolutionitem;                            

                            // Get OutputFile Settings                           
                            //Get whether output file mode is visible or not.
                            scans.optionStateOutputFileVisible.Checked = scanSApplicationSetting.ScanSetting.OutputFile.Visible;                            
                            //Get whether Scan Setting Output File Edit is allowed or not.
                            scans.optionStateOutputFileAllowEdit.Checked = scanSApplicationSetting.ScanSetting.OutputFile.AllowEdit;
                            
                            //Get Selectable output modes
                            scans.textBoxOutputFieSelectable.Text = scanSApplicationSetting.ScanSetting.OutputFile.SelectableItems.Count.ToString();
                            
                            //OutputFile number
                            count = 1;

                            string outputfielitem = "";
                            foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanOutputFileItem scanOutputFileItem in scanSApplicationSetting.ScanSetting.OutputFile.SelectableItems)
                            {
                                //Get the type of Output File Item Type
                                outputfielitem += count + ". " + scanOutputFileItem.Type; ;                            
                                if (scanOutputFileItem.Selected)
                                {
                                    outputfielitem += "(Default Output Type)";                                    
                                }
                                outputfielitem += Environment.NewLine;                                
                                count++;
                            }
                            scans.textBoxOutputFileList.Text = outputfielitem;
                            
                            //Get Custom Setting Screen Buttons
                            //Get Custom Setting Screen Button Size        
                            scans.textBoxScreenButtonSize.Text = scanSApplicationSetting.StaticCustomSettingScreen.ButtonSize.ToString();                            
                            //Get Custom Setting Screen ID 
                            scans.textBoxScreedId.Text = scanSApplicationSetting.StaticCustomSettingScreen.ID;
                            //Get Custom Setting Screen Language Code
                            scans.textBoxScreenLangCode.Text = scanSApplicationSetting.StaticCustomSettingScreen.LangCode.ToString();                            
                            //Get Custom Setting Screen Message
                            scans.textBoxScreenMsg.Text = scanSApplicationSetting.StaticCustomSettingScreen.Message;                            
                            //Get Static Custom Setting Screen Type
                            scans.textBoxScreenButtonSize.Text = scanSApplicationSetting.StaticCustomSettingScreen.Type.ToString();                            
                            //Get Custom Setting Input Controls

                            string customsettings = "";
                            foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.StaticCustomSetting staticCustomSetting in scanSApplicationSetting.StaticCustomSettingScreen.StaticCustomSettings)
                            {
                                //Get Static Custom Setting ID
                                customsettings += "Static Custom Setting ID : " + staticCustomSetting.ID + Environment.NewLine;                            
                                //Get Static Custom Setting Name
                                customsettings += "Static Custom Setting Name : " + staticCustomSetting.Name + Environment.NewLine;                                
                                //Get Static Custom Setting Message
                                customsettings += "Static Custom Setting Message : " + staticCustomSetting.Message + Environment.NewLine;                                
                                //Get Static Custom Setting Icon Number
                                customsettings += "Static Custom Setting Icon Number : " + staticCustomSetting.IconNo + Environment.NewLine;                                
                                customsettings += Environment.NewLine;                                
                                //Get Custom Setting Input Controls
                                count = 1;
                                foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControl inputControl in staticCustomSetting.InputControls)
                                {
                                    customsettings += "Input Control " + count + " Settings " + Environment.NewLine;                                    
                                    customsettings += GetControlDetails(inputControl);                                    
                                    count++;
                                    customsettings += Environment.NewLine;                                    
                                }
                            }
                            scans.textBoxInputControls.Text = customsettings;
                            //Get Encryption Setting if encryption is enabled
                            scans.groupBoxEncryptionSettings.Enabled = scanSApplicationSetting.ImageTransfer.Encryption.Enable;
                            if (scanSApplicationSetting.ImageTransfer.Encryption.Enable)
                            {                                
                                //Get Encryption IV Value
                                scans.textBoxIV.Text = scanSApplicationSetting.ImageTransfer.Encryption.IV;                             
                                //Get Encryption Key Value
                                scans.textBoxKey.Text = scanSApplicationSetting.ImageTransfer.Encryption.Key;                                
                            }
                            
                            
                            //Get Image Transfer Protocol type                            
                            switch (scanSApplicationSetting.ImageTransfer.ProtocolType)
                            {
                                case KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ImageTransferProtocolType.Ftp:
                                    //Show the FTP groupbox
                                    scans.groupBoxFTP.Visible = true;
                                    //Hide the WebDav groupbox
                                    scans.groupBoxWebDav.Visible = false;
                                    //Get FTP Details                                    
                                    KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.FtpImageTransferSetting ftpImageTransferSetting = (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.FtpImageTransferSetting)scanSApplicationSetting.ImageTransfer;
                                    //Get FTP Address
                                    scans.textBoxFTPAddress.Text = ftpImageTransferSetting.Address;                                    
                                    //Get FTP Allow Anonymous
                                    scans.optionStateAllowAnonymous.Checked = ftpImageTransferSetting.AllowAnonymous;                                    
                                    //Get FTP Directory
                                    scans.textBoxFTPDirectory.Text = ftpImageTransferSetting.Directory;                                    
                                    //Get FTP Passive - Enabled or Disabled
                                    scans.optionStatePassive.Checked = ftpImageTransferSetting.UsePassive;                                    
                                    //Get FTP -Proxy ON or OFF
                                    scans.optionStateUseProxy.Checked = ftpImageTransferSetting.UseProxy;                                    
                                    //Get FTP User Name
                                    scans.textBoxFTPUserName.Text = ftpImageTransferSetting.UserName;                                    
                                    //Get FTP User Password
                                    scans.textBoxFTPPwd.Text = ftpImageTransferSetting.UserPassword;                                    
                                    break;

                                case KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ImageTransferProtocolType.WebDAV:
                                    //Hide the FTP groupbox
                                    scans.groupBoxFTP.Visible = false;
                                    //Show the WebDav groupbox
                                    scans.groupBoxWebDav.Visible = true;
                                    //Get WebDAV settings                                    
                                    KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.WebDAVImageTransferSetting webDAVImageTransferSetting = (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.WebDAVImageTransferSetting)scanSApplicationSetting.ImageTransfer;
                                    //Get WebDAV Address
                                    scans.textBoxWebDavAddress.Text = webDAVImageTransferSetting.Address;                                    
                                    //Get WebDAV Directory
                                    scans.textBoxWebDavDirectory.Text = webDAVImageTransferSetting.Directory;                                    
                                    //Get WebDAV SSL - ON or OFF
                                    scans.optionStateWebdavSSL.Checked = webDAVImageTransferSetting.UseSSL;                                    
                                    //Get WebDAV Proxy - Enabled or Disabled
                                    scans.optionStateWebDavProxy.Checked = webDAVImageTransferSetting.UseProxy;                                    
                                    //Get WebDAV User Name
                                    scans.textBoxWebDavUsername.Text = webDAVImageTransferSetting.UserName;
                                    szDetails += " WebDAV User Name -->  " + webDAVImageTransferSetting.UserName + Environment.NewLine;
                                    //Get WebDAV User Password
                                    scans.textBoxWebDavPwd.Text = webDAVImageTransferSetting.UserPassword;                                    
                                    break;
                            }
                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Fill the text area with the details
                            getDetails.textBoxDetails = szDetails;
                            //Adding component to FlowlayoutPanel to resize form automatically
                            getDetails.flowLayoutPanel.Controls.Add(scans);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "PullPrint":
                        #region Get PullPrint Application Details
                        //Get the application details of PullPrint Function

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.PullApplicationSetting pullApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.PullApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetPullApplication(iAppNo, szAppID, out pullApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {                                                     
                            //Get the application server details                            
                            //Get the Server Address                            
                            serverdetails.textBoxAddress.Text = pullApplicationSetting.Server.Address;
                            //Get the Server Port                            
                            serverdetails.textBoxPort.Text = pullApplicationSetting.Server.Port.ToString();
                            // Get SSL Settings                            
                            serverdetails.optionStateSSL.Checked = pullApplicationSetting.Server.UseSSL;
                            // Get Server Timeout
                            serverdetails.textBoxTimeOut.Text = pullApplicationSetting.Server.Timeout.ToString();
                            
                            //Get Authentication Type                            
                            serverdetails.textBoxAuthenticationType.Text = pullApplicationSetting.Function.AuthenticationType.ToString();                            

                            //Get Application Node
                            serverdetails.textBoxAppNode.Text = pullApplicationSetting.Function.AppNode;                                                      

                            //Get Job Notify Server Settings                 
                            serverdetails.optionStateJobNotify.Checked = pullApplicationSetting.Function.EnableJobNotify;
                            serverdetails.groupBoxJobNotify.Enabled = pullApplicationSetting.Function.EnableJobNotify;
                            if (pullApplicationSetting.Function.EnableJobNotify)
                            {                           
                                //Get the Job Notification Address                             
                                serverdetails.textBoxJobNotifyAddress.Text = pullApplicationSetting.Function.JobNotifyServer.Address;
                                //Get the Job Notification Port No                                
                                serverdetails.textBoxJobNotifyPort.Text = pullApplicationSetting.Function.JobNotifyServer.Port.ToString();
                                //Get the Job Notification Server SSL is ON or OFF
                                serverdetails.optionStateJobNotifySSL.Checked=pullApplicationSetting.Function.JobNotifyServer.UseSSL;                                
                            }
                            // Check WithRelayServerAuthentication Setting Enabled or not.
                            serverdetails.optionStateRelayServerAuth.Checked = pullApplicationSetting.Function.WithRelayServerAuthentication;

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically
                            getDetails.flowLayoutPanel.Controls.Add(serverdetails);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Job Management":
                        MessageBox.Show("Application Details are not present for Job Management applications.");
                        szDetails += "Application Details are not present for Job Management applications.";
                        break;
                    case "Authentication":

                        Authentication auth = new Authentication();

                        #region Get Authentication Application Details
                        //Get the application Details of Authentication Application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.AuthApplicationSetting authApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.AuthApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetAuthApplication(iAppNo, szAppID, out authApplicationSetting);

                        //connectResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //Authentication Application Details                           

                            //Get Authentication Screen Details                                                        
                            //Get Authentication Screen ID
                            auth.textBoxScreenId.Text = authApplicationSetting.AuthenticationScreen.ID;                            
                            //Get Authentication Screen language code
                            auth.textBoxScreenLangCode.Text = authApplicationSetting.AuthenticationScreen.LangCode.ToString();                            
                            //Get Authentication Screen Message
                            auth.textBoxScreenMessage.Text = authApplicationSetting.AuthenticationScreen.Message;                                                        
                            //Get Authentication Screen Type
                            auth.textBoxScreenType.Text = authApplicationSetting.AuthenticationScreen.Type.ToString();

                            //Get Authentication Screen Link Button
                            if (authApplicationSetting.AuthenticationScreen.LinkButton != null)
                            {
                                //Get Authentication Link Button Details
                                //Check whether link button Display is enabled or not
                                auth.groupBoxLnkButton.Enabled = authApplicationSetting.AuthenticationScreen.LinkButton.Enable;
                                auth.optionStateLnkBtnEnable.Checked = authApplicationSetting.AuthenticationScreen.LinkButton.Enable;                                
                                //Get the link button ID
                                auth.textBoxLnkBtnId.Text = authApplicationSetting.AuthenticationScreen.LinkButton.ID;                                
                                //Get the link button name
                                auth.textBoxLnkBtnName.Text = authApplicationSetting.AuthenticationScreen.LinkButton.Name;
                                //Get the link button Next Screen ID
                                auth.textBoxLnkNextScreenId.Text = authApplicationSetting.AuthenticationScreen.LinkButton.NextScreenID;                                
                            }
                            else
                            {
                                //Disabling LinkButton groupbox
                                auth.groupBoxLnkButton.Enabled = false;
                            }

                            //Get the various input Controls used
                            string strinputcontrol = "";
                            int counter = 1;
                            foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControl inputControl in authApplicationSetting.AuthenticationScreen.InputControls)
                            {
                                strinputcontrol += "Input Control " + counter + "Settings";                                
                                strinputcontrol += GetControlDetails(inputControl);                                
                                counter++;
                                strinputcontrol += Environment.NewLine;                                
                            }
                            auth.textBoxInputControl.Text = strinputcontrol;
                            //Get Authentication Primary Server Details                            
                            //Get Primary Server Address
                            auth.textBoxPrimaryAddress.Text = authApplicationSetting.PrimaryServer.Address;                            
                            //Get Primary Server Port
                            auth.textBoxPrimaryPort.Text = authApplicationSetting.PrimaryServer.Port.ToString();                            
                            //Get Primary Server Timeout
                            auth.textBoxPrimaryTimeOut.Text = authApplicationSetting.PrimaryServer.Timeout.ToString();
                            
                            //Get Authentication Secondary Server Details                            
                            //Get Secondary Server Address
                            auth.textBoxSecAddress.Text = authApplicationSetting.SecondaryServer.Address;                            
                            //Get Secondary Server Port
                            auth.textBoxSecTimeOut.Text = authApplicationSetting.SecondaryServer.Port.ToString();                            
                            //Get Secondary Server Timeout
                            auth.textBoxSecTimeOut.Text = authApplicationSetting.SecondaryServer.Timeout.ToString();                           
                            
                            //Get Authentication Usage Details -Whether Authentication Function is enabled or not. 
                            auth.optionStateUseAuthentication.Checked = authApplicationSetting.Function.UseAuthentication;                            
                            auth.optionStateOffHookQuickSendType.Checked = authApplicationSetting.Function.IsDisplayConfirmationScreen;
                            //Get Counter Limit usage Details - If Counter Limitation is enabled.
                            auth.groupBoxCounterLimitation.Enabled = authApplicationSetting.Function.UseCounterLimit;
                            auth.optionStateCounterLimitaion.Checked = authApplicationSetting.Function.UseCounterLimit;
                            if (authApplicationSetting.Function.UseCounterLimit)
                            {
                                auth.textBoxCounterBalanceType.Text = authApplicationSetting.Function.CounterLimit.DisplayBalanceType.ToString();
                                //Get Job Delete Type
                                auth.textBoxCounterDeleteType.Text = authApplicationSetting.Function.CounterLimit.JobDelete.JobDelete.ToString();
                                //Get Job Delete Expire Time
                                auth.textBoxCounterExpireTime.Text = authApplicationSetting.Function.CounterLimit.JobDelete.ExpireTime.ToString();                            
                            }
                            
                            //Get Function Limitation Usage Details - Whether Function Limitation is enabled or not.
                            auth.optionStateUseFucntionLimitaion.Checked = authApplicationSetting.Function.UseFunctionLimit;
                            
                            //Get Counter Notify Usage Details - If Counter Notify is enabled                            
                            auth.optionStateUseCounterNotify.Checked = authApplicationSetting.Function.UseCounterNotify;                           
                            
                            // Get Credit Limit Settings - If Credit Limitation is enabled.
                            auth.groupBoxCreditLimitaion.Enabled = authApplicationSetting.Function.UseCreditLimit;
                            auth.optionStateCreditLimitaion.Checked = authApplicationSetting.Function.UseCreditLimit;
                            if (authApplicationSetting.Function.UseCreditLimit)
                            {
                                //Get whether Credit Display Balance is displayed or not.
                                auth.optionStateCreditIsBalanceType.Checked = authApplicationSetting.Function.CreditLimit.IsDisplayBalance;                            
                                auth.textBoxCreditBalanceType.Text = authApplicationSetting.Function.CreditLimit.DisplayBalanceType.ToString();

                                //Get Credit Limit Job Delete Expire Time
                                auth.textBoxCreditExpireTime.Text = authApplicationSetting.Function.CreditLimit.JobDelete.ExpireTime.ToString();
                                //Get Credit Limit Job Delete Type
                                auth.textBoxCreditDeleteType.Text = authApplicationSetting.Function.CreditLimit.JobDelete.JobDelete.ToString();
                                //Get Credit Limit OffHookQuickSendTyp value
                                auth.optionStateOffHookQuickSendType.Checked = authApplicationSetting.Function.CreditLimit.EnableOffHookQuickSendType;
                            }                          
                           
                            // Get Default Application Settings - If Default Application is enabled.
                            auth.optionStateDefaultApplication.Checked = authApplicationSetting.Function.UseDefaultApplication;
                            auth.groupBoxDefaultApp.Enabled = authApplicationSetting.Function.UseDefaultApplication;
                            if (authApplicationSetting.Function.UseDefaultApplication)
                            {                           
                                //Get Default application Panel Edit Setting
                                auth.optionStateDfltappPanelEdit.Checked = authApplicationSetting.Function.DefaultApplicatin.AllowPanelEdit;                             
                            }
                            
                            //Get My Panel Settings
                            auth.groupBoxMyPanel.Enabled = authApplicationSetting.Function.UseMyPanel;
                            auth.optionStateMyPanel.Checked = authApplicationSetting.Function.UseMyPanel;
                            if (authApplicationSetting.Function.UseMyPanel)
                            {                            
                                // Get MyPanel Panel Edit Settings
                                auth.optionStateMypnlPanelEdit.Checked = authApplicationSetting.Function.MyPanel.AllowPanelEdit;
                             
                                //Get Mypanel Program Memory Shortcut Settings
                                auth.optionStateProgramMemoryShortCut.Checked = authApplicationSetting.Function.MyPanel.AllowProgramMemoryShortCut;
                             
                            }
                            
                            //Hide BrowserInfo groupbox
                            auth.groupBoxBrowserInfo.Visible = false;
                            
                            //Show label in BrowserDetails tab
                            auth.labelBrowserInfo.Visible = true;
                            auth.tabControl1.TabPages[3].Controls.Add(auth.labelBrowserInfo);
                            auth.labelBrowserInfo.Dock = DockStyle.Fill;
                            auth.labelBrowserInfo.Padding = new Padding(40);

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically                           
                            getDetails.flowLayoutPanel.Controls.Add(auth);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Setup":
                        //A Setup application can't actually be registered, but it's listed here for "completeness"
                        MessageBox.Show("Application Details are not present for Setup applications.");
                        szDetails += "Application Details are not present for Setup applications.";
                        break;
                    case "Browser Authentication":
                        #region Get Authentication Browser Application Details
                        Authentication authbrowser = new Authentication();                      
                        // Get the application details of Authentication Browser application
                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.AuthBrowserApplicationSetting authBrowserApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.AuthBrowserApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetAuthBrowserApplication(iAppNo, szAppID, out authBrowserApplicationSetting);

                        //connectResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {                         
                            //Get Authentication Screen Details                         
                            //Get Authentication Screen ID                            
                            authbrowser.textBoxScreenId.Text = authBrowserApplicationSetting.AuthenticationScreen.ID; 
                            //Get Authentication Screen language code
                            authbrowser.textBoxScreenLangCode.Text = authBrowserApplicationSetting.AuthenticationScreen.LangCode.ToString();
                            //Get Authentication Screen Message
                            authbrowser.textBoxScreenMessage.Text = authBrowserApplicationSetting.AuthenticationScreen.Message;                                                        
                            //Get Authentication Screen Type
                            authbrowser.textBoxScreenType.Text = authBrowserApplicationSetting.AuthenticationScreen.Type.ToString();
                            
                            //Get Authentication Screen Link Button
                            if (authBrowserApplicationSetting.AuthenticationScreen.LinkButton != null)
                            {
                                //Get Authentication Link Button Details                            

                                //Check whether link button Display is enabled or not
                                authbrowser.groupBoxLnkButton.Enabled = authBrowserApplicationSetting.AuthenticationScreen.LinkButton.Enable;
                                authbrowser.optionStateLnkBtnEnable.Checked = authBrowserApplicationSetting.AuthenticationScreen.LinkButton.Enable;                                
                                //Get the link button ID
                                authbrowser.textBoxScreenId.Text = authBrowserApplicationSetting.AuthenticationScreen.LinkButton.ID;                                
                                //Get the link button name
                                authbrowser.textBoxLnkBtnName.Text = authBrowserApplicationSetting.AuthenticationScreen.LinkButton.Name;                                
                                //Get the link button Next Screen ID
                                authbrowser.textBoxLnkNextScreenId.Text = authBrowserApplicationSetting.AuthenticationScreen.LinkButton.NextScreenID;                                
                            }

                            //Get the various input Controls used
                            string authbrowserInputctrl="";
                            int counter = 1;
                            foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControl inputControl in authBrowserApplicationSetting.AuthenticationScreen.InputControls)
                            {
                                authbrowserInputctrl += "Input Control " + counter + "Settings";                               
                                authbrowserInputctrl += GetControlDetails(inputControl);
                                authbrowserInputctrl += Environment.NewLine;
                            }
                            authbrowser.textBoxInputControl.Text = authbrowserInputctrl;
                            
                            //Get Browser Settings                            
                            //Get Browser Cookie
                            authbrowser.textBoxCookie.Text = authBrowserApplicationSetting.Browser.Cookie.ToString();                            
                            //Get Browser Folder ID
                            authbrowser.textBoxFolderId.Text = authBrowserApplicationSetting.Browser.FolderID;
                            //Get Browser Primary Server Local Content URL
                            authbrowser.textBoxPrimaryLocalContents.Text = authBrowserApplicationSetting.Browser.PrimaryLocalContents;                            
                            //Get Browser Secondary Server Local Content URL
                            authbrowser.textBoxSecLocalContents.Text = authBrowserApplicationSetting.Browser.SecondaryLocalContents;
                            
                            //Get Authentication Primary Server Details                            
                            //Get Primary Server Address
                            authbrowser.textBoxPrimaryAddress.Text = authBrowserApplicationSetting.PrimaryServer.Address;                            
                            //Get Primary Server Port
                            authbrowser.textBoxPrimaryPort.Text = authBrowserApplicationSetting.PrimaryServer.Port.ToString();                            
                            //Get Primary Server Timeout
                            authbrowser.textBoxPrimaryTimeOut.Text = authBrowserApplicationSetting.PrimaryServer.Timeout.ToString();                            
                            //Get Authentication Secondary Server Details
                            //Get Secondary Server Address
                            authbrowser.textBoxSecAddress.Text = authBrowserApplicationSetting.SecondaryServer.Address;                            
                            //Get Secondary Server Port
                            authbrowser.textBoxSecPort.Text = authBrowserApplicationSetting.SecondaryServer.Port.ToString();                            
                            //Get Secondary Server Timeout
                            authbrowser.textBoxSecTimeOut.Text = authBrowserApplicationSetting.SecondaryServer.Timeout.ToString();                            
                            //Get Authentication Usage Details -Whether Authentication Function is enabled or not. 
                            authbrowser.optionStateUseAuthentication.Checked = authBrowserApplicationSetting.Function.UseAuthentication;
                            
                            //Get Counter Limit usage Details - If Counter Limitation is enabled.
                            authbrowser.groupBoxCounterLimitation.Enabled = authBrowserApplicationSetting.Function.UseCounterLimit;
                            authbrowser.optionStateCounterLimitaion.Checked = authBrowserApplicationSetting.Function.UseCounterLimit;
                            if (authBrowserApplicationSetting.Function.UseCounterLimit)
                            {                            
                                //Get Job Delete Type
                                authbrowser.textBoxCounterDeleteType.Text = authBrowserApplicationSetting.Function.CounterLimit.JobDelete.JobDelete.ToString();
                             
                                //Get Job Delete Expire Time
                                authbrowser.textBoxCounterExpireTime.Text = authBrowserApplicationSetting.Function.CounterLimit.JobDelete.ExpireTime.ToString();
                            }                           
                            
                            //Get Function Limitation Usage Details - Whether Function Limitation is enabled or not.
                            authbrowser.optionStateUseFucntionLimitaion.Checked = authBrowserApplicationSetting.Function.UseFunctionLimit;
                            
                            //Get Counter Notify Usage Details - If Counter Notify is enabled                            
                            authbrowser.optionStateUseCounterNotify.Checked = authBrowserApplicationSetting.Function.UseCounterNotify;
                            
                            // Get Credit Limit Settings - If Credit Limitation is enabled.
                            authbrowser.groupBoxCreditLimitaion.Enabled = authBrowserApplicationSetting.Function.UseCounterNotify;
                            authbrowser.optionStateCreditLimitaion.Checked = authBrowserApplicationSetting.Function.UseCreditLimit;
                            if (authBrowserApplicationSetting.Function.UseCreditLimit)
                            {
                                //Get Credit Limit DisplayBalanceType
                                authbrowser.textBoxCreditBalanceType.Text = authBrowserApplicationSetting.Function.CreditLimit.DisplayBalanceType.ToString();                               

                                //Get whether Credit Display Balance is displayed or not.
                                authbrowser.optionStateCreditIsBalanceType.Checked = authBrowserApplicationSetting.Function.CreditLimit.IsDisplayBalance;
                             
                                //Get Credit Limit Job Delete Expire Time
                                authbrowser.textBoxCreditExpireTime.Text = authBrowserApplicationSetting.Function.CreditLimit.JobDelete.ExpireTime.ToString();                             
                                //Get Credit Limit Job Delete Type
                                authbrowser.textBoxCreditDeleteType.Text = authBrowserApplicationSetting.Function.CreditLimit.JobDelete.JobDelete.ToString();

                                authbrowser.optionStateOffHookQuickSendType.Checked = authBrowserApplicationSetting.Function.CreditLimit.EnableOffHookQuickSendType;
                                
                            }                            
                            

                            // Get Default Application Settings - If Default Application is enabled.
                            authbrowser.groupBoxDefaultApp.Enabled = authBrowserApplicationSetting.Function.UseDefaultApplication;
                            authbrowser.optionStateDefaultApplication.Checked = authBrowserApplicationSetting.Function.UseDefaultApplication;
                            if (authBrowserApplicationSetting.Function.UseDefaultApplication)
                            {                             
                                //Get Default application Panel Edit Setting
                                authbrowser.optionStateDfltappPanelEdit.Checked = authBrowserApplicationSetting.Function.DefaultApplicatin.AllowPanelEdit;
                             
                            }                           
                            

                            //Get My Panel Settings
                            authbrowser.groupBoxMyPanel.Enabled = authBrowserApplicationSetting.Function.UseMyPanel;
                            authbrowser.optionStateMyPanel.Checked = authBrowserApplicationSetting.Function.UseMyPanel;
                            if (authBrowserApplicationSetting.Function.UseMyPanel)
                            {
                                // Get MyPanel Panel Edit Settings
                                authbrowser.optionStateMypnlPanelEdit.Checked = authBrowserApplicationSetting.Function.MyPanel.AllowPanelEdit;
                                //Get Mypanel Program Memory Shortcut Settings
                                authbrowser.optionStateProgramMemoryShortCut.Checked = authBrowserApplicationSetting.Function.MyPanel.AllowProgramMemoryShortCut;                             
                            }

                            //Show browser info groupbox in BrowserDetails tab
                            authbrowser.groupBoxBrowserInfo.Visible = true;

                            //Hide the browser info label 
                            authbrowser.labelBrowserInfo.Visible = false;


                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically
                            getDetails.flowLayoutPanel.Controls.Add(authbrowser);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Browser Scan":
                        #region Get Scan Browser Application Details
                        //Get the application details of Scan Browser application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanBrowserApplicationSetting scanBrowserApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScanBrowserApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetScanApplication(iAppNo, szAppID, out scanBrowserApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //Get Browser Settings                        
                            //Get Browser Cookie
                            browserinfo.textBoxCookie.Text = scanBrowserApplicationSetting.Browser.Cookie.ToString();                            
                            //Get Browser Folder ID
                            browserinfo.textBoxFolderId.Text = scanBrowserApplicationSetting.Browser.FolderID;                            
                            // Checks whether usage of Local Contents enabled ot not.
                            browserinfo.optionStateUseLocalContents.Checked = scanBrowserApplicationSetting.Browser.UseLocalContents;
                            if (scanBrowserApplicationSetting.Browser.UseLocalContents)
                            {                                
                                //Get Browser Local Contents
                                browserinfo.textBoxLocalContents.Text = scanBrowserApplicationSetting.Browser.LocalContents;                             
                            }

                            browserinfo.textBoxTimeOut.Text = scanBrowserApplicationSetting.Browser.Timeout.ToString();
                            //Get Browser Primary Server URL
                            browserinfo.textBoxURL.Text = scanBrowserApplicationSetting.Browser.Url.AbsoluteUri;

                            //Get the Application Server Information                            
                            //Get Server Address                            
                            serverdetails.textBoxAddress.Text = scanBrowserApplicationSetting.Server.Address;
                            
                            //Get Server Port No
                            serverdetails.textBoxPort.Text = scanBrowserApplicationSetting.Server.Port.ToString();
                            
                            //Get whether SSL is ON or OFF
                            serverdetails.optionStateSSL.Checked = scanBrowserApplicationSetting.Server.UseSSL;
                            
                            //Get Server Timeout information
                            serverdetails.textBoxTimeOut.Text = scanBrowserApplicationSetting.Server.Timeout.ToString();

                            //Scan doesn't contain AppNode, so they are hidden
                            serverdetails.labelAppNode.Visible = false;
                            serverdetails.textBoxAppNode.Visible = false;
                            //Get the Authentication Type
                            serverdetails.textBoxAuthenticationType.Text = scanBrowserApplicationSetting.Function.AuthenticationType.ToString();
                            
                            //scanBrowserApplicationSetting.Function.EnableJobNotify means Job Notification is enabled
                            serverdetails.groupBoxJobNotify.Enabled = scanBrowserApplicationSetting.Function.EnableJobNotify;
                            serverdetails.optionStateJobNotify.Checked = scanBrowserApplicationSetting.Function.EnableJobNotify;
                            if (scanBrowserApplicationSetting.Function.EnableJobNotify)
                            {                            
                                //Get the Job Notification Address
                                serverdetails.textBoxJobNotifyAddress.Text = scanBrowserApplicationSetting.Function.JobNotifyServer.Address;                             
                                //Get the Job Notification Port No
                                serverdetails.textBoxJobNotifyPort.Text = scanBrowserApplicationSetting.Function.JobNotifyServer.Port.ToString();                                
                                //Get the Job Notification Server SSL is ON or OFF
                                serverdetails.optionStateJobNotifySSL.Checked = scanBrowserApplicationSetting.Function.JobNotifyServer.UseSSL;                                
                            }

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically
                            getDetails.flowLayoutPanel.Controls.Add(serverdetails);
                            getDetails.flowLayoutPanel.Controls.Add(browserinfo);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Browser PullPrint":
                        #region Get PullPrint Browser Application Details
                        //Get the application details of PullPrint Browser application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.PullBrowserApplicationSetting pullBrowserApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.PullBrowserApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetPullBrowserApplication(iAppNo, szAppID, out pullBrowserApplicationSetting);
                        
                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {                         
                            //Get Browser Settings                         
                            //Get Browser Cookie
                            browserinfo.textBoxCookie.Text = pullBrowserApplicationSetting.Browser.Cookie.ToString();                            
                            //Get Browser Folder ID
                            browserinfo.textBoxFolderId.Text = pullBrowserApplicationSetting.Browser.FolderID;                            
                            // Checks whether usage of Local Contents enabled ot not.
                            browserinfo.optionStateUseLocalContents.Checked = pullBrowserApplicationSetting.Browser.UseLocalContents;
                            if (pullBrowserApplicationSetting.Browser.UseLocalContents)
                            {
                                //Get Browser Local Contents
                                browserinfo.textBoxLocalContents.Text = pullBrowserApplicationSetting.Browser.LocalContents;                                
                            }

                            //Get Browser Primary Server URL
                            browserinfo.textBoxURL.Text = pullBrowserApplicationSetting.Browser.Url.AbsoluteUri;
                            browserinfo.textBoxTimeOut.Text = pullBrowserApplicationSetting.Browser.Timeout.ToString();

                            //Get the Application Server Information
                            //Get Server Address
                            serverdetails.textBoxAddress.Text = pullBrowserApplicationSetting.Server.Address;
                            //Get Server Port No
                            serverdetails.textBoxPort.Text = pullBrowserApplicationSetting.Server.Port.ToString();
                            szDetails += "Server Port -->  " + pullBrowserApplicationSetting.Server.Port + Environment.NewLine;
                            serverdetails.textBoxAppNode.Text = pullBrowserApplicationSetting.Function.AppNode;
                            //Get whether SSL is ON or OFF
                            serverdetails.optionStateSSL.Checked = pullBrowserApplicationSetting.Server.UseSSL;                            
                            //Get Server Timeout information
                            serverdetails.textBoxTimeOut.Text = pullBrowserApplicationSetting.Server.Timeout.ToString();
                            //Get the Authentication Type
                            serverdetails.textBoxAuthenticationType.Text = pullBrowserApplicationSetting.Function.AuthenticationType.ToString();
                            
                            //pullBrowserApplicationSetting.Function.EnableJobNotify means Job Notification is enabled
                            serverdetails.groupBoxJobNotify.Enabled = pullBrowserApplicationSetting.Function.EnableJobNotify;
                            serverdetails.optionStateJobNotifySSL.Checked = pullBrowserApplicationSetting.Function.EnableJobNotify;
                            if (pullBrowserApplicationSetting.Function.EnableJobNotify)
                            {                            
                                //Get the Job Notification Address
                                serverdetails.textBoxJobNotifyAddress.Text = pullBrowserApplicationSetting.Function.JobNotifyServer.Address;                             
                                //Get the Job Notification Port No
                                serverdetails.textBoxJobNotifyPort.Text = pullBrowserApplicationSetting.Function.JobNotifyServer.Port.ToString();                                
                                //Get the Job Notification Server SSL is ON or OFF
                                serverdetails.optionStateJobNotifySSL.Checked = pullBrowserApplicationSetting.Function.JobNotifyServer.UseSSL;                               
                            }
                            
                            // Check WithRelayServerAuthentication Setting Enabled or not.
                            serverdetails.optionStateRelayServerAuth.Checked = pullBrowserApplicationSetting.Function.WithRelayServerAuthentication;

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically                            
                            getDetails.flowLayoutPanel.Controls.Add(serverdetails);
                            getDetails.flowLayoutPanel.Controls.Add(browserinfo);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Screen Saver":
                        #region Get ScreenSaver Application Details
                        //Get the application details of Screen Saver application
                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScreenSaverApplicationSetting screenSaverApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.ScreenSaverApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetScreenSaverApplication(iAppNo, szAppID, out screenSaverApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //Get Browser Settings                         
                            //Get Browser Cookie
                            browserinfo.textBoxCookie.Text = screenSaverApplicationSetting.Browser.Cookie.ToString();                            
                            //Get Browser Folder ID
                            browserinfo.textBoxFolderId.Text = screenSaverApplicationSetting.Browser.FolderID;                            
                            //Get Browser Timeout
                            browserinfo.textBoxTimeOut.Text = screenSaverApplicationSetting.Browser.Timeout.ToString();                           

                            // Get Browser Local Contents Setting
                            browserinfo.optionStateUseLocalContents.Checked = screenSaverApplicationSetting.Browser.UseLocalContents;
                            if (screenSaverApplicationSetting.Browser.UseLocalContents)
                            {                                
                                //Get Browser Local Contents
                                browserinfo.textBoxLocalContents.Text = screenSaverApplicationSetting.Browser.LocalContents;                             
                            }                          

                            //Get Screen Saver Application URL
                            browserinfo.textBoxURL.Text = screenSaverApplicationSetting.Browser.Url.ToString();

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically                            
                            getDetails.flowLayoutPanel.Controls.Add(browserinfo);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "Browser Launcher":
                        BrowserLauncher browserlauncher = new BrowserLauncher();
                        #region Get Browser Launcher  Application Details
                        //Get the application details of Browser Launcher application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.BrowserLauncherApplicationSetting browserLauncherApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.BrowserLauncherApplicationSetting();

                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetBrowserLauncherApplication(iAppNo, szAppID, out browserLauncherApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //Get BrowserLauncher Settings 
                            //Get BrowserLauncher Application ID
                            browserlauncher.textBoxId.Text = browserLauncherApplicationSetting.ID;
                            //Get BrowserLauncher Application Name
                            browserlauncher.textBoxName.Text = browserLauncherApplicationSetting.Name;
                            //Get BrowserLauncher Application Node
                            browserlauncher.textBoxNode.Text = browserLauncherApplicationSetting.Node;
                            //Get BrowserLauncher Application No
                            browserlauncher.textBoxNo.Text = browserLauncherApplicationSetting.No.ToString();

                            ////Get BrowserLauncher Application StatusBar and ToolBar status
                            browserlauncher.optionStateStatusBar.Checked = browserLauncherApplicationSetting.ShowStatusBar;
                            browserlauncher.optionStateToolBar.Checked = browserLauncherApplicationSetting.ShowToolBar;
                            
                            //Get the browser launcher URL
                            browserlauncher.textBoxURL.Text = browserLauncherApplicationSetting.Url.AbsoluteUri;

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically                            
                            getDetails.flowLayoutPanel.Controls.Add(browserlauncher);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    case "OtherA":
                        MessageBox.Show("Application Details are not present for OtherA applications.");
                        szDetails += "Application Details are not present for OtherA applications.";
                        break;
                    case "General Browser":
                        #region Get Genaral Browser Application Details
                        //Get the application details of Genaral Browser application

                        //Initialise our "result" for GetApplicationDetails
                        KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.GeneralBrowserApplicationSetting generalBrowserApplicationSetting = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationSettingNS.GeneralBrowserApplicationSetting();
                        
                        //Get the application details - this returns ConnectionResult
                        connectionResult = openAPIHandler.GetGeneralBrowserApplication(iAppNo, szAppID, out generalBrowserApplicationSetting);

                        //connectionResult == "Ack" means success
                        if (connectionResult == KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.ConnectionResult.Ack)
                        {
                            //Get Browser Settings                         
                            //Get Browser Cookie
                            browserinfo.textBoxCookie.Text = generalBrowserApplicationSetting.Browser.Cookie.ToString();
                            //Get Browser Folder ID
                            browserinfo.textBoxFolderId.Text = generalBrowserApplicationSetting.Browser.FolderID;
                            // Checks whether usage of Local Contents enabled ot not.
                            browserinfo.optionStateUseLocalContents.Checked = generalBrowserApplicationSetting.Browser.UseLocalContents;
                            if (generalBrowserApplicationSetting.Browser.UseLocalContents)
                            {
                                //Get Browser Local Contents
                                browserinfo.textBoxLocalContents.Text = generalBrowserApplicationSetting.Browser.LocalContents;
                            }

                            //Get Browser Primary Server URL
                            if (generalBrowserApplicationSetting.Browser.Url != null)
                            {
                                browserinfo.textBoxURL.Text = generalBrowserApplicationSetting.Browser.Url.AbsoluteUri;
                            }
                            browserinfo.textBoxTimeOut.Text = generalBrowserApplicationSetting.Browser.Timeout.ToString();

                            //Get the Application Server Information
                            //Get Server Address
                            serverdetails.textBoxAddress.Text = generalBrowserApplicationSetting.Server.Address;
                            //Get Server Port No
                            serverdetails.textBoxPort.Text = generalBrowserApplicationSetting.Server.Port.ToString();
                            szDetails += "Server Port -->  " + generalBrowserApplicationSetting.Server.Port + Environment.NewLine;
                            serverdetails.textBoxAppNode.Text = generalBrowserApplicationSetting.Function.AppNode;
                            //Get whether SSL is ON or OFF
                            serverdetails.optionStateSSL.Checked = generalBrowserApplicationSetting.Server.UseSSL;
                            //Get Server Timeout information
                            serverdetails.textBoxTimeOut.Text = generalBrowserApplicationSetting.Server.Timeout.ToString();
                            //Get the Authentication Type
                            serverdetails.textBoxAuthenticationType.Text = generalBrowserApplicationSetting.Function.AuthenticationType.ToString();

                            //generalbrowserApplicationSetting.Function.EnableJobNotify means Job Notification is enabled
                            serverdetails.groupBoxJobNotify.Enabled = generalBrowserApplicationSetting.Function.EnableJobNotify;
                            serverdetails.optionStateJobNotifySSL.Checked = generalBrowserApplicationSetting.Function.EnableJobNotify;
                            if (generalBrowserApplicationSetting.Function.EnableJobNotify)
                            {
                                //Get the Job Notification Address
                                serverdetails.textBoxJobNotifyAddress.Text = generalBrowserApplicationSetting.Function.JobNotifyServer.Address;
                                //Get the Job Notification Port No
                                serverdetails.textBoxJobNotifyPort.Text = generalBrowserApplicationSetting.Function.JobNotifyServer.Port.ToString();
                                //Get the Job Notification Server SSL is ON or OFF
                                serverdetails.optionStateJobNotifySSL.Checked = generalBrowserApplicationSetting.Function.JobNotifyServer.UseSSL;
                            }

                            // Check WithRelayServerAuthentication Setting Enabled or not.
                            serverdetails.optionStateRelayServerAuth.Checked = generalBrowserApplicationSetting.Function.WithRelayServerAuthentication;

                            //Dispalying application details
                            frmGetDetails getDetails = new frmGetDetails();
                            //Adding component to FlowlayoutPanel to resize form automatically                            
                            getDetails.flowLayoutPanel.Controls.Add(serverdetails);
                            getDetails.flowLayoutPanel.Controls.Add(browserinfo);
                            //Adding Close button to RightBottom of the form
                            getDetails.buttonClose.Dock = DockStyle.Right;
                            //Adding Close button
                            getDetails.flowLayoutPanel.Controls.Add(getDetails.buttonClose);
                            //Display the dialog to the user
                            getDetails.ShowDialog();
                        }
                        else
                        {
                            //connectionResult == "NAck"
                            MessageBox.Show("Failed to Get the Application Details", "Note", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            return;
                        }
                        break;
                        #endregion
                    default:
                        MessageBox.Show("Application Details are not present for unknown application types.");
                        szDetails += "Application Details are not present for unknown application types.";
                        break;
                }
            }
            catch (Exception ex)
            {
                //Common reasons we may hit this catch are network communication errors such as incorrect IP address, port number etc, or simply that the MFP has OpenAPI disabled
                MessageBox.Show("Failed to communicate with MFP" + Environment.NewLine + Environment.NewLine + "(" + ex.Message + ")", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

        }

        private void buttonDeleteAll_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(new ParameterizedThreadStart(DeleteApps));
            Dictionary<int, string> dApps = new Dictionary<int, string>();
            foreach (ListViewItem lvi in listViewApps.Items)
                dApps.Add(int.Parse(lvi.SubItems[1].Text), lvi.SubItems[0].Text);
            progressBar.Maximum = dApps.Count;
            t.Start(dApps);
        }

        private void DeleteApps(object o)
        {
            BeBusy(true);
            Dictionary<int, string> dAppsToDelete = (Dictionary<int, string>)o;
            KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection resAppList = new KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfoCollection();
            ConnectionResult cr;
            try
            {
                Progress("Logging in to MFP", false);
                cr = openAPIHandler.Login();
                if (cr == ConnectionResult.Ack)
                {
                    Progress("Checking application list in case it's changed", false);
                    cr = openAPIHandler.GetApplicationList(out resAppList);
                    if (cr == ConnectionResult.Ack)
                    {
                        Progress("Retrieved application list", false);
                        Dictionary<int, string> dAppsOnMFP = new Dictionary<int, string>();
                        foreach (KONICAMINOLTA.OpenAPISDK.SequenceSetupLibrary.IF.ApplicationInfoNS.ApplicationInfo app in resAppList)
                            dAppsOnMFP.Add(app.No, app.Name);

                        foreach (KeyValuePair<int, string> kvpApp in dAppsToDelete)
                        {
                            if (dAppsOnMFP.ContainsKey(kvpApp.Key))
                            {
                                if (dAppsOnMFP[kvpApp.Key] == kvpApp.Value)
                                {
                                    Progress("Deleting " + kvpApp.Value, false);
                                    cr = openAPIHandler.DeleteApplication(kvpApp.Key);
                                    if (cr == ConnectionResult.Ack)
                                    {
                                        Progress("Deleted " + kvpApp.Value);
                                        RemoveLVI(kvpApp.Value);
                                    }
                                    else
                                    {
                                        //Failed to delete...
                                        string szError = "Failed to delete " + kvpApp.Value;
                                        try
                                        {
                                            szError += ": " + openAPIHandler.SetupMainControlManager.LastConnectionError.ErrorInfoList.StatusErrorInfo[0].Result.ErrorInfo.Description;
                                        }
                                        catch { }
                                        RecordError(szError);
                                        Progress(szError);
                                    }
                                }
                                else
                                {
                                    //App isn't the same...
                                    string szError = kvpApp.Value + " already appears to be gone from number " + kvpApp.Key.ToString() + " (" + dAppsOnMFP[kvpApp.Key] + " is there instead)";
                                    RecordError(szError);
                                    Progress(szError);
                                }
                            }
                            else
                            {
                                //No app at that number...
                                string szError = kvpApp.Value + " already appears to be gone from number " + kvpApp.Key.ToString();
                                RecordError(szError);
                                Progress(szError);
                            }
                        }
                    }
                    else
                    {
                        //Error encountered getting application list
                        string szError = "Failed to get application list";
                        try
                        {
                            szError += ": " + openAPIHandler.SetupMainControlManager.LastConnectionError.ErrorInfoList.StatusErrorInfo[0].Result.ErrorInfo.Description;
                        }
                        catch { }
                        RecordError(szError);
                        Progress(szError);
                    }
                }
                else
                {
                    //Error encountered logging in
                    string szError = "Failed to log in to MFP";
                    try
                    {
                        szError += ": " + openAPIHandler.SetupMainControlManager.LastConnectionError.ErrorInfoList.StatusErrorInfo[0].Result.ErrorInfo.Description;
                    }
                    catch { }
                    RecordError(szError);
                    Progress(szError);
                }
            }
            catch (Exception ex)
            {
                //Other error encountered
                string szError = "Critical error encountered, forced to stop: " + ex.Message;
                RecordError(szError);
                Progress(szError);
            }
            try
            {
                openAPIHandler.Logout();
            }
            catch { }
            BeBusy(false);
        }

        private delegate void ListClearDelegate();
        private void ListClear()
        {
            listViewApps.Items.Clear();
        }
        private void ClearList()
        {           
                if (this.InvokeRequired)
                    this.Invoke(new ListClearDelegate(ListClear));
                else
                    ListClear();
          
        }

        private delegate void ErrorRecordDelegate(string ErrorMessage);
        private void ErrorRecord(string ErrorMessage)
        {
            errorMessage += ErrorMessage + Environment.NewLine;
        }
        private void RecordError(string ErrorMessage)
        {
                if(this.InvokeRequired)
                this.Invoke(new ErrorRecordDelegate(ErrorRecord), ErrorMessage);
                else
                    ErrorRecord(ErrorMessage);
          
        }

        private delegate void ProgressBarAdvanceDelegate(string ProgressText, bool Advance);
        private void ProgressBarAdvance(string ProgressText, bool Advance)
        {
            if (Advance)
            {
                if (progressBar.Value == progressBar.Maximum)
                    progressBar.Value = 0;
                progressBar.Value++;
            }
            labelProgress.Text = ProgressText;
        }

        private void Progress(string ProgressText)
        {           
              if (this.InvokeRequired)
                  this.Invoke(new ProgressBarAdvanceDelegate(ProgressBarAdvance), ProgressText, true);
              else
                  ProgressBarAdvance(ProgressText,true);
          
        }
        private void Progress(string ProgressText, bool Advance)
        {
            if (this.InvokeRequired)
                this.Invoke(new ProgressBarAdvanceDelegate(ProgressBarAdvance), ProgressText, Advance);
            else
                ProgressBarAdvance(ProgressText, Advance);
        }

        private delegate void LVIRemoveDelegate(string AppName);
        private void LVIRemove(string AppName)
        {
            ListViewItem lviRemove = null;
            foreach (ListViewItem lvi in listViewApps.Items)
            {
                if ((string)lvi.Tag == AppName)
                {
                    lviRemove = lvi;
                    break;
                }
            }
            if (lviRemove != null)
                listViewApps.Items.Remove(lviRemove);
        }
        private void RemoveLVI(string AppName)
        {
            if (this.InvokeRequired)
                this.Invoke(new LVIRemoveDelegate(LVIRemove), AppName);
            else
                LVIRemove(AppName);
          
        }

        private delegate void LVIAddDelegate(ListViewItem lvi);
        private void LVIAdd(ListViewItem lvi)
        {
            foreach (ListViewItem lviCheck in listViewApps.Items)
            {
                if (lviCheck.SubItems[0].Text == lvi.SubItems[0].Text &&
                    lviCheck.SubItems[1].Text == lvi.SubItems[1].Text &&
                    lviCheck.SubItems[2].Text == lvi.SubItems[2].Text)
                    return;
            }
            listViewApps.Items.Add(lvi);
        }
        private void AddLVI(ListViewItem lvi)
        {
            
            if (this.InvokeRequired)
                this.Invoke(new LVIAddDelegate(LVIAdd), lvi);
            else
                LVIAdd(lvi);
        
        }

        private delegate void BusyDelegate(bool AmBusy);
        private void Busy(bool AmBusy)
        {
            pictureBoxBusy.Visible = AmBusy;
            buttonRefresh.Visible = !AmBusy;
            buttonRefresh.Enabled = !AmBusy;
                        
            listViewApps.Enabled = !AmBusy;
            buttonDeleteAll.Enabled = !AmBusy;
            progressBar.Value = 0;
            if (AmBusy)
            {
                listViewApps.Height -= 42;
                buttonDeleteAll.Top -= 42;
                progressBar.Visible = true;
                labelProgress.Visible = true;

                buttonDelete.Enabled = false;
            }
            else
            {
                if (errorMessage != string.Empty)
                    MessageBox.Show(errorMessage, "Notification", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                errorMessage = string.Empty;
                listViewApps.Height += 42;
                buttonDeleteAll.Top += 42;
                progressBar.Visible = false;
                labelProgress.Visible = false;
                labelProgress.Text = string.Empty;
                if (listViewApps.SelectedItems.Count > 0)
                    buttonDelete.Enabled = true;
            }
        }
        private void BeBusy(bool AmBusy)
        {
            if (this.InvokeRequired)
                this.Invoke(new BusyDelegate(Busy), AmBusy);
            else
                Busy(AmBusy);
          
        }

        private void listViewApps_SelectedIndexChanged(object sender, EventArgs e)
        {
            buttonDelete.Enabled = (listViewApps.SelectedItems.Count != 0);
            buttonGetDetails.Enabled = (listViewApps.SelectedItems.Count == 1);
        }

        //This method is used to get the details of the Controls present in the registered application(Authentication and Scan Type S Application)  
        private String GetControlDetails(KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControl inputControl)
        {
            String szControlDetails = String.Empty;

            //Get Control Details common to all the control types
            # region Common Control Details
            //Get Control ID
            szControlDetails += "Control ID --> " + inputControl.ID + Environment.NewLine;
            //Get Control Edit Type
            szControlDetails += "Control Edit Type --> " + inputControl.EditType + Environment.NewLine;
            //Get Control Icon Number
            szControlDetails += "Control Icon Number --> " + inputControl.IconNo + Environment.NewLine;
            //Get Control Meaning Type
            szControlDetails += "Control Meaning Type --> " + inputControl.MeaningType + Environment.NewLine;
            //Get Control Message
            szControlDetails += "Control Message --> " + inputControl.Message + Environment.NewLine;
            //Get Control Name
            szControlDetails += "Control Name --> " + inputControl.Name + Environment.NewLine;
            //Get Control Usage Type
            szControlDetails += "Control Usage Type --> " + inputControl.UsageType + Environment.NewLine;
            //Get Control Type
            szControlDetails += "Control Type --> " + inputControl.Type + Environment.NewLine;
            #endregion

            //Get control details specific to each control by checking the type of control
            switch (inputControl.Type)
            {
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.String:
                    #region String Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StringControl stringControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StringControl)inputControl;
                    //Get String Control  Asterisk Display Type
                    szControlDetails += "String Control  Asterisk Display Type  --> " + stringControl.AsteriskDisplayType + Environment.NewLine;
                    //Get String Control Keyboard Type
                    szControlDetails += "String Control  Keyboard Type  --> " + stringControl.KeyBoardType + Environment.NewLine;
                    //Get String Control Maximum Length
                    szControlDetails += "String Control  Maximum Length  --> " + stringControl.MaxLength + Environment.NewLine;
                    //Get String Control Minimum Length
                    szControlDetails += "String Control Minimum Length  --> " + stringControl.MinLength + Environment.NewLine;
                    //Get String Control Text
                    szControlDetails += "String Control Text :" + stringControl.Text + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.StringSelection:
                    #region String Selection Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StringSelectionControl stringSelectionControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StringSelectionControl)inputControl;
                    //Get String Selection Control  Button Size
                    szControlDetails += "String Selection Control Button Size --> " + stringSelectionControl.ButtonSize + Environment.NewLine;
                    //Get String Selection Control  KeyBoard Type
                    szControlDetails += "String Selection Control KeyBoard Type --> " + stringSelectionControl.KeyBoardType + Environment.NewLine;
                    //Get String Selection Control List Button ID
                    szControlDetails += "String Selection Control List Button ID --> " + stringSelectionControl.ListButton.ID + Environment.NewLine;
                    //Get String Selection Control List Button Name
                    szControlDetails += "String Selection Control List Button Name --> " + stringSelectionControl.ListButton.Name + Environment.NewLine;
                    //Get String Selection Control List Button Next Screen ID
                    szControlDetails += "String Selection Control List Button Next Screen ID --> " + stringSelectionControl.ListButton.NextScreenID + Environment.NewLine;
                    //Get String Selection Control Maximum Length
                    szControlDetails += "String Selection Control  Maximum Length  --> " + stringSelectionControl.MaxLength + Environment.NewLine;
                    //Get String Selection Control Minimum Length
                    szControlDetails += "String Selection Control Minimum Length  --> " + stringSelectionControl.MinLength + Environment.NewLine;
                    //Get the static control selections
                    int count = 0;
                    foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection in stringSelectionControl.Selections)
                    {
                        szControlDetails += " String Selection Control " + count + Environment.NewLine;
                        szControlDetails += GetSelectionControlDetails(selection);
                        szControlDetails += Environment.NewLine;
                        count++;
                    }
                    //Get String Selection Control Text
                    szControlDetails += "String Selection Control Text  --> " + stringSelectionControl.Text + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.Text:
                    #region Text Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.TextControl textControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.TextControl)inputControl;
                    //Get Text Control text 
                    szControlDetails += "Text Control text : " + textControl.Text + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.Toggle:
                    #region Toggle Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.ToggleControl toggleControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.ToggleControl)inputControl;
                    //Get Toggle Control False Button Name
                    szControlDetails += "Toggle Control False Button Name -->  " + toggleControl.FalseButtonName + Environment.NewLine;
                    //Get Toggle Control True Button Name
                    szControlDetails += "Toggle Control True Button Name  -->  " + toggleControl.TrueButtonName + Environment.NewLine;
                    //Get Toggle Control State
                    szControlDetails += "Toggle Control State  -->  " + toggleControl.State + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.StaticSelection:
                    #region Static Selection Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StaticSelectionControl staticSelectionControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StaticSelectionControl)inputControl;
                    //Get Static Selection Control Button Size
                    szControlDetails += "Static Selection Control Button Size --> " + staticSelectionControl.ButtonSize + Environment.NewLine;
                    //Get Static Selection Control Default ID
                    szControlDetails += "Static Selection Control Default ID --> " + staticSelectionControl.DefaultID + Environment.NewLine;
                    //Get Static Selection Control Selections
                    szControlDetails += "Static Selection Control Selections -->  " + Environment.NewLine;
                    //Get Static Selection Control Selections
                    count = 1;
                    foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection in staticSelectionControl.Selections)
                    {
                        szControlDetails += " String Selection Control " + count + Environment.NewLine;
                        szControlDetails += GetSelectionControlDetails(selection);
                        szControlDetails += Environment.NewLine;
                        count++;
                    }
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.StaticMultipleSelection:
                    #region Static Multiple Selection Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StaticMultipleSelectionControl staticMultipleSelectionControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.StaticMultipleSelectionControl)inputControl;
                    //Get Static Multiple Selection Control Button Size
                    szControlDetails += "Static Multiple Selection Control Button Size --> " + staticMultipleSelectionControl.ButtonSize + Environment.NewLine;
                    //Get Static multiple selections
                    count = 0;
                    foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection in staticMultipleSelectionControl.MultipleSelections)
                    {
                        szControlDetails += " Static Multiple Selection Control " + count + Environment.NewLine;
                        szControlDetails += GetSelectionControlDetails(selection);
                        szControlDetails += Environment.NewLine;
                        count++;
                    }
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.SearchString:
                    #region Get Search String Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.SearchStringControl searchStringControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.SearchStringControl)inputControl;
                    //Get Search String Control Keyboard Type
                    szControlDetails += "Search String Control Keyboard Type -->  " + searchStringControl.KeyBoardType + Environment.NewLine;
                    //Get Search String Control List Button ID
                    szControlDetails += "Search String Control List Button ID -->  " + searchStringControl.ListButton.ID + Environment.NewLine;
                    //Get Search String Control List Button Name
                    szControlDetails += "Search String Control List Button Name -->  " + searchStringControl.ListButton.Name + Environment.NewLine;
                    //Get Search String Control Next Screen ID
                    szControlDetails += "Search String Control Next Screen ID -->  " + searchStringControl.ListButton.NextScreenID + Environment.NewLine;
                    //Get Search String Control Maximum Length
                    szControlDetails += "Search String Control Maximum Length -->  " + searchStringControl.MaxLength + Environment.NewLine;
                    //Get Search String Control Minimum Length
                    szControlDetails += "Search String Control Minimum Length -->  " + searchStringControl.MinLength + Environment.NewLine;
                    //Get Search String Selections
                    count = 0;
                    foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection in searchStringControl.Selections)
                    {
                        szControlDetails += " Search String Selection Control " + count + Environment.NewLine;
                        szControlDetails += GetSelectionControlDetails(selection);
                        szControlDetails += Environment.NewLine;
                        count++;
                    }
                    //Get Search String Control Button Size
                    szControlDetails += "Search String Control Button Size -->  " + searchStringControl.ButtonSize + Environment.NewLine;
                    //Get Search String Control Text
                    szControlDetails += "Search String Control Text -->  " + searchStringControl.Text + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.Numeric:
                    #region Numeric Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.NumericControl numericControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.NumericControl)inputControl;
                    //Get Numeric Control Asterisk Display Type
                    szControlDetails += "Numeric Control Asterisk Display Type -->  " + numericControl.AsteriskDisplayType + Environment.NewLine;
                    //Get Numeric Control Input Type
                    szControlDetails += "Numeric Control Input Type -->  " + numericControl.InputType + Environment.NewLine;
                    //Get Numeric Control Minimum Length
                    szControlDetails += "Numeric Control Minimum Length  -->  " + numericControl.MinLength + Environment.NewLine;
                    //Get Numeric Control Maximum Length
                    szControlDetails += "Numeric Control Maximum Length -->  " + numericControl.MaxLength + Environment.NewLine;
                    //Get Numeric Control Value
                    szControlDetails += "Numeric Control Value  -->  " + numericControl.Value + Environment.NewLine;
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.DynamicSelection:
                    #region Dynamic Selection Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.DynamicSelectionControl dynamicSelectionControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.DynamicSelectionControl)inputControl;
                    //Get Dynamic Selection Control Button Size
                    szControlDetails += "Dynamic Selection Control Button Size --> " + dynamicSelectionControl.ButtonSize + Environment.NewLine;
                    //Get Dynamic Selection Control Selections
                    szControlDetails += "Dynamic Selection Control Selections" + Environment.NewLine;
                    count = 0;
                    foreach (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection in dynamicSelectionControl.Selections)
                    {
                        szControlDetails += " Dynamic Selection Control " + count + Environment.NewLine;
                        szControlDetails += GetSelectionControlDetails(selection);
                        szControlDetails += Environment.NewLine;
                        count++;
                    }
                    break;
                    #endregion
                case KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.InputControlType.DateAndTime:
                    #region Date and Time Control Details
                    KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.DateAndTimeControl dateAndTimeControl = (KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.DateAndTimeControl)inputControl;
                    //Get Date and Time Control Date Time Format
                    szControlDetails += "Date and Time Control Date Time Format -->  " + dateAndTimeControl.DateTimeFormat + Environment.NewLine;
                    //Get Date and Time Control Year
                    szControlDetails += " Date and Time Control Year -->  " + dateAndTimeControl.Year + Environment.NewLine;
                    //Get Date and Time Control Month
                    szControlDetails += " Date and Time Control Month -->  " + dateAndTimeControl.Month + Environment.NewLine;
                    //Get Date and Time Control Day
                    szControlDetails += "Date and Time Control Day -->  " + dateAndTimeControl.Day + Environment.NewLine;
                    //Get Date and Time Control Hour
                    szControlDetails += "Date and Time Control Hour -->  " + dateAndTimeControl.Hour + Environment.NewLine;
                    //Get Date and Time Control Minute
                    szControlDetails += "Date and Time Control Minute -->  " + dateAndTimeControl.Minute + Environment.NewLine;
                    //Get Date and Time Control UTC Offset 
                    szControlDetails += "Date and Time Control UTC Offset -->  " + dateAndTimeControl.UtcOffset + Environment.NewLine;
                    //Get Date and Time Control Default Type
                    szControlDetails += " Date and Time Control Default Type -->  " + dateAndTimeControl.DefaultType + Environment.NewLine;
                    break;
                    #endregion
            }
            return szControlDetails;

        }

        //This method is used to get the details of the Selection Controls which are part of various Input Controls present registered application
        //like String Selection Control, Multiple Selection Control and Search String Selection Control.  
        private String GetSelectionControlDetails(KONICAMINOLTA.OpenAPISDK.SequencePanelLibrary.IF.Controls.Input.Selection selection)
        {
            String szSelectionControlDetails = String.Empty;
            //Get Selection Control ID
            szSelectionControlDetails += " Selection Control ID -->  " + selection.ID + Environment.NewLine;
            //Get Selection Control Name
            szSelectionControlDetails += " Selection Control Name -->  " + selection.Name + Environment.NewLine;
            //Get whether the control is selected or not
            if (selection.Selected)
                szSelectionControlDetails += " Selection Control  -->  Selected " + Environment.NewLine;
            else
                szSelectionControlDetails += "Selection Control  -->  Not Selected  " + Environment.NewLine;

            return szSelectionControlDetails;
        }
    }
}
